clear
clc

% 1. 定义文件路径与读取矩阵
load_path = 'D:\1-Postgraduate-work\1 Doctoral work\1 Scientific research work\量子计算\矩阵测试\网壳刚度阵\n=7\K1.mat';
data = load(load_path);  % 读取MAT文件到结构体
K1 = data.K1;            % 提取目标矩阵K1

% 2. 新增：在主程序中判断矩阵K1的对称性（迁移自sppaoli函数）
% 原理：通过 Frobenius 范数判断矩阵与其转置的差异，小于1e-13视为对称
symmetry_norm = norm(K1 - K1', 'fro');  % 计算矩阵与转置的Frobenius范数
is_symmetric = (symmetry_norm < 1e-13); % 布尔值：true=对称，false=非对称
% 2. 用if-else定义对称性描述字符串（替换三元运算符）
if is_symmetric
    symmetry_desc = '对称';  % 条件为真时：对称
else
    symmetry_desc = '非对称';% 条件为假时：非对称
end

% 3. 正常打印（此时传入的是已定义好的字符串变量，无语法错误）
fprintf('矩阵对称性判断结果：%s（Frobenius范数差异：%.6e）\n', ...
        symmetry_desc, symmetry_norm);

% 3. 初始化时间统计与循环参数
total_time = 0;          % 总运行时间累加器
loop_count = 5;          % 循环运行次数
type_flag = 'dec';       % 第2个参数：输出类型（保持原逻辑）
%[a, DD] = sppaoli_1008(K1, type_flag, is_symmetric);
[a, DD] = sppaoli_1008(K1, type_flag, is_symmetric);
[a, DD] = sppaoli_1008(K1, type_flag, is_symmetric);

% 4. 循环运行稀疏泡利分解（传入对称性参数）
for i = 1:loop_count
    tic;  % 开始计时
    
    % 核心修改：调用sppaoli时传入4个参数：矩阵、类型、对称性、验证开关
    [a, DD] = sppaoli_1008(K1, type_flag, is_symmetric);
    
    elapsed_time = toc;  % 结束计时，获取单次运行时间
    fprintf('第%d次运行时间：%.6f 秒\n', i, elapsed_time);
    total_time = total_time + elapsed_time;  % 累加总时间
end

% 5. 计算并显示平均时间
average_time = total_time / loop_count;
fprintf('------------------------\n');
fprintf('平均运行时间：%.6f 秒\n', average_time);