function quatVec = dec2quat_vector(n_dec, n_digits)
    % dec2quat_vector 将十进制数转换为固定n位的四进制横向量
    %   输入: 
    %       n_dec - 十进制非负整数
    %       n_digits - 四进制数的位数
    %   输出: 
    %       quatVec - 对应的n位四进制横向量，每个元素为0-3的整数
    
    % 输入验证
    if n_dec < 0 || floor(n_dec) ~= n_dec
        error('第一个输入必须是非负整数');
    end
    if n_digits < 1 || floor(n_digits) ~= n_digits
        error('第二个输入必须是正整数');
    end
    
    % 计算n位四进制能表示的最大值
    max_value = 4^n_digits - 1;
    if n_dec > max_value
        error(['超出', num2str(n_digits), '位四进制的表示范围(最大可表示', num2str(max_value), ')']);
    end
    
    % 初始化向量
    quatVec = zeros(1, n_digits);
    
    % 特殊情况：0的四进制表示
    if n_dec == 0
        return;  % 全为0的向量
    end
    
    % 转换为四进制数字
    temp = n_dec;
    position = n_digits;  % 从最右边（最低位）开始
    
    while temp > 0 && position >= 1
        remainder = mod(temp, 4);
        quatVec(position) = remainder;  % 存储当前位
        temp = floor(temp / 4);
        position = position - 1;
    end
end
